using System;

class Program
{
    static int BinarnaPretraga(int X,int[] glasovi, int levi, int desni)
    {
        if( desni >= levi)
        {
            int srednji = levi + (desni - levi) / 2;
            if (glasovi[srednji] > X)
            {
                return BinarnaPretraga(X, glasovi, levi, srednji - 1);
            }
            else if (glasovi[srednji] < X)
            {
                return BinarnaPretraga(X, glasovi, srednji + 1, desni);
            }
            else
            {
                return srednji;
            }
        }
        return -1;
    }

    static int PribliznaVrednost(int X, int N, int[] glasovi)
    {
        for(int i = 0; i < N - 1; i++) 
        {
            if (X > glasovi[i] && X < glasovi[i + 1])
            {
                return i;
            }
        }
        return 0;
    }

    static int BrojGlasova(int X, int N, int[] glasovi)
    {
        if (X < glasovi[0] || X > glasovi[N - 1])
        {
            return N;
        }
        else
        {
            int k = BinarnaPretraga(X, glasovi, 0, N - 1);
            if(k == -1)
            {
                k = PribliznaVrednost(X, N, glasovi);
            }
            return Math.Abs(N / 2 - k);
        }
    }
    static void Main()
    {
        string[] brojevi = Console.ReadLine().Split(' ');
        int N = int.Parse(brojevi[0]);
        int Q = int.Parse(brojevi[1]);
        
        int[] glasovi = new int[N];
        string[] a = Console.ReadLine().Split(' ');
        for(int i = 0; i < N; i++)
            glasovi[i] = int.Parse(a[i]);
        
        Array.Sort(glasovi);

        string[] b = Console.ReadLine().Split(' '); 
        for(int i = 0; i < Q; i++)
        {
            int X = int.Parse(b[i]);
            Console.WriteLine(BrojGlasova(X,N,glasovi));
        }
        
        Console.ReadLine();
    }
}